<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006 onwards Catalyst IT Ltd (http://www.catalyst.net.nz)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage lang (Japanese)
 * @translator Mitsuhiro Yoshida (http://mitstek.com/)
 * @started    2008-01-19 11:25:00 UTC
 * @updated    2010-03-13 01:31:00 UTC
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2006 onwards Catalyst IT Ltd http://catalyst.net.nz
 *
 */

defined('INTERNAL') || die();

$string['pluginname'] = 'ラーニング';
$string['mylearning'] = 'マイラーニング';
$string['learningsaved'] = 'ラーニングサーベイが保存されました。';
$string['learningsavefailed'] = 'あなたのラーニングサーベイ更新に失敗しました。';
$string['multipleintelligences'] = '複合インテリジェンス';
$string['multipleintelligencesdesc'] = '<p>複合インテリジェンス理論は、1983年、Howard Gardner博士によって開発されました。この理論では、IQテストに基づくインテリジェンスの伝統的な概念が、あまりにも限定され過ぎていると主張しています。代わりに、Gardner博士は、子供および成人の幅広い潜在能力から成る7つの異なるインテリジェンスを提案しました。8番目のインテリジェンスは、1990年代半ばに、同じく、Gardner博士によって考案されました。これらのインテリジェンスは、下記のとおりです:
<ul>
<li><b>言語的インテリジェンス</b> - 言葉を話す、または書く能力です。</li>
<li><b>論理-数学的インテリジェンス</b> - 帰納的および演繹的考察および論理的思考の能力です。数字および抽象的なパターン認識と同様に論理を使用します。</li>
<li><b>視覚-空間的インテリジェンス</b> - 心の中で目的物および空間サイズを視覚化する能力です。</li>
<li><b>運動感覚的インテリジェンス</b> - 身体に関する知識および身体的動作をコントロールする能力です。</li>
<li><b>音楽的インテリジェンス</b> - 音楽と同様にリズム、音程、拍子を習得する能力です。</li>
<li><b>対人的インテリジェンス</b> - 他の人との効果的なコミュニケーションを図り、関係を築くことのできる能力です。</li>
<li><b>内省的インテリジェンス</b> - 自分自身の感情、モチベーション、内部状態および内省を理解することのできる能力です。</li>
<li><b>博物学的インテリジェンス</b> - 自然界および環境に関して、差異を識別することのできる能力です。</li>
</ul>
</p>';
$string['learningstyles'] = 'ラーニングスタイル';
$string['learningstylesdesc'] = '<p>ラーニングスタイルは、学びに対する、単純に異なるアプローチまたは方法です。これらは、教育方法、特に個人が最良に学べると推定される教育方法を含みます。様々なラーニングスタイルの中で最も一般的であり、広範囲で使われているカテゴリ化は、初期の神経言語プログラミングモデルを拡張したFlemings VARKモデル (VAK) です:
<ul>
<li><b>視覚的学習者</b> - これらの学習者は、見ること (絵、オーバーヘッドスライド等の視覚教材、図表、資料等によって考えること) を好みます。</li>
<li><b>聴覚的学習者</b> - これらの学習者は、聴くこと (講義、ディスカッション、オーディオ等) により、最も良く学ぶことができます。</li>
<li><b>読み/書き優先傾向学習者</b> - これらの学習者は、読むことおよび書くことにより、最も良く学ぶことができます。</li>
<li><b>運動感覚的学習者</b>または<b>触知的学習者</b> - これらの学習者は、経験 - 動く、触る、実行する (世界の探査、科学プロジェクト、実験等) により学ぶことを好みます。</li>
</ul>
</p>';
$string['legend'] = '凡例';
$string['dateadded'] = '作成日:';
$string['intelligenceA'] = '言語的インテリジェンス';
$string['intelligenceB'] = '論理-数学的インテリジェンス';
$string['intelligenceC'] = '視覚-空間的インテリジェンス';
$string['intelligenceD'] = '運動感覚的インテリジェンス';
$string['intelligenceE'] = '音楽的インテリジェンス';
$string['intelligenceF'] = '対人的インテリジェンス';
$string['intelligenceG'] = '内省的インテリジェンス';
$string['intelligenceH'] = '博物学的インテリジェンス';
$string['true'] = '○';
$string['false'] = '×';
$string['multipleintelligences.A1'] = '自分のアイデアを他の人に説明することは、私にとって簡単です。';
$string['multipleintelligences.A2'] = '私は、会話、講義および他の人の話を聞くことから多くを学びます。';
$string['multipleintelligences.A3'] = '私は、演説およびディベートへの参加を楽しみます。';
$string['multipleintelligences.A4'] = 'ノートを取ることは、私の記憶および理解に役立ちます。';
$string['multipleintelligences.B1'] = '段階的な指示は、大いに役立ちます。';
$string['multipleintelligences.B2'] = '問題解決および論理パズルは、私にとって簡単です。';
$string['multipleintelligences.B3'] = '私は、経験または物事の間に、パターンおよび関連性を簡単に見出すことができます。';
$string['multipleintelligences.B4'] = '私は、頭の中で素早く計算できます。';
$string['multipleintelligences.C1'] = '私は、地図および設計図を読むことが得意です。';
$string['multipleintelligences.C2'] = '私は、図表、グラフおよびグラフィックオーガナイザを使用した方が良く記憶できます。';
$string['multipleintelligences.C3'] = '私は、アイデアを心の中で視覚化することができます。';
$string['multipleintelligences.C4'] = '私は、物事または光景をイメージとして思い出すことができます。';
$string['multipleintelligences.D1'] = '私は、物を手で作ることを楽しみます。';
$string['multipleintelligences.D2'] = '私は、自分自身で何かを実行することにより、最も良く学ぶことができます。';
$string['multipleintelligences.D3'] = '私には良いバランス感覚があり、あちこち移動することが好きです。';
$string['multipleintelligences.D4'] = '非常に忙しいより、忙しくない方が私をより疲れさせます。';
$string['multipleintelligences.E1'] = '歌詞およびメロディを記憶することは、私にとって簡単です。';
$string['multipleintelligences.E2'] = '悲しいとき、私は、音楽で元気になることができます。';
$string['multipleintelligences.E3'] = '私は、複雑な演奏から、個々の楽器を識別することができます。';
$string['multipleintelligences.E4'] = '私は、歌うこと、または楽器の演奏を楽しみます。';
$string['multipleintelligences.F1'] = 'しばしば、私は、同級生および同僚の間でリーダーとして働きます。';
$string['multipleintelligences.F2'] = '私は、グループイベントおよび社会的イベントを楽しみます。';
$string['multipleintelligences.F3'] = '私は、周りの人の気分および感情に敏感です。';
$string['multipleintelligences.F4'] = '私は、チームプレイヤーであり、他の人との会話から最も良く学びます。';
$string['multipleintelligences.G1'] = '自分の行動および自分自身に対して、私には責任があると信じます。';
$string['multipleintelligences.G2'] = '学ぶことに同意する前、私は、なぜ学ばなければならないのか、知る必要があります。';
$string['multipleintelligences.G3'] = '私は、ひとりでいること、私の人生について考えること、私自身のことを考えることを楽しみます。';
$string['multipleintelligences.G4'] = 'ひとりで作業をすることは、グループで作業をすることと同じく、生産性が上がります。';
$string['multipleintelligences.H1'] = '私にとって、分類することは、新しいデータの理解に役立ちます。';
$string['multipleintelligences.H2'] = '私は、自宅の植物およびペットの世話をすることを楽しみます。';
$string['multipleintelligences.H3'] = '私は、月、潮の干満のような自然現象を観察することが好きです。また、それらに関して、説明を聞くことも好きです。';
$string['multipleintelligences.H4'] = '私は、特に生物学、植物学、動物学のような自然に関して学ぶことが好きです。';
$string['learningtypeV'] = '視覚タイプ';
$string['learningtypeA'] = '聴覚タイプ';
$string['learningtypeK'] = '運動感覚タイプ';
$string['never'] = 'ない';
$string['rarely'] = 'めったにない';
$string['sometimes'] = '時々ある';
$string['often'] = 'よくある';
$string['always'] = 'いつもある';
$string['learningstyles.V01'] = '教室では、私は教師との良いアイコンタクトを持続します。';
$string['learningstyles.V02'] = 'ノートを取る場合、または教材を読む場合、私は色 (鉛筆、クレヨン等) を使います。';
$string['learningstyles.V03'] = '必要のある場合、私は道順を記述するより、地図を描くことを好みます。';
$string['learningstyles.V04'] = '私は、地図、図表、グラフ等を簡単に理解および読むことができます。';
$string['learningstyles.V05'] = '私が何かに取り組んでいる場合、ラジオのスイッチを入れると困ってしまいます。';
$string['learningstyles.V06'] = '説明文を読む場合、聞く場合、私は、ノートを多く取ります。';
$string['learningstyles.V07'] = '私がテストを書く場合、私が答えを学んだノートのページ、または本を容易に頭の中に描くことができます。';
$string['learningstyles.V08'] = '私は、ノートを取った方が良く記憶できます。';
$string['learningstyles.V09'] = '例えば誰かの電話番号のように、私が何かを記憶したい場合、心の中にそのイメージを作ることが記憶に役立ちします。';
$string['learningstyles.V10'] = '私は、読む内容、または聞く内容を心の中で想像することができます。';
$string['learningstyles.V11'] = '私は、誰かに読んでもらうより、自分ひとりで読む方が良いと思います。';
$string['learningstyles.A01'] = '何かを他の人と話す場合、私は簡単にそれを理解します。';
$string['learningstyles.A02'] = '私は、書面での指示より、口頭での指示を好みます。';
$string['learningstyles.A03'] = '私は、テキストを自分自身で読むより、オーディオブック等、音声で聴くことを好みます。';
$string['learningstyles.A04'] = '私は、口頭の質問より、記述テストの方が悪い結果となります。';
$string['learningstyles.A05'] = '聞き慣れない物、イベント、施設等を想像することは、私にとって難しいことです。';
$string['learningstyles.A06'] = '私は冗談を言うことが大好きで、それらを簡単に記憶することができます。';
$string['learningstyles.A07'] = '私は、説明を良く理解することができますが、教師との良いアイコンタクトを持続することはできません。';
$string['learningstyles.A08'] = '私は、話しながら書くことが好きです。';
$string['learningstyles.A09'] = '私が読む場合、心の中で言葉に耳を傾けます。';
$string['learningstyles.A10'] = '私は、人の外観を良く記憶することはできませんが、人の言葉を良く記憶することができます。';
$string['learningstyles.A11'] = '私は、声に出した方が、資料を良く記憶することができます。';
$string['learningstyles.K01'] = '私が運動している場合、良いアイデアを生み出せます。';
$string['learningstyles.K02'] = '私が学ぶ場合、机に座るのではなく、異なる場所を好みます (例 床、ベッド等)。';
$string['learningstyles.K03'] = '私は、メモを取りますが、少々整理されていません。';
$string['learningstyles.K04'] = '私は、長時間静かに座ることができません。';
$string['learningstyles.K05'] = '私は、手作業が好きです。';
$string['learningstyles.K06'] = '私が学ぶ場合、多くの休憩が必要です。';
$string['learningstyles.K07'] = '私が話す場合、同時にボディランゲージを使用します (例 ジェスチャ)。';
$string['learningstyles.K08'] = '成果物の作り方のインストラクションを聞くより、私は、すぐに作業に入ることを好みます。';
$string['learningstyles.K09'] = '説明を聞く場合、私は、しばしば紙または作業台に落書きします。';
$string['learningstyles.K10'] = '私は、学んでいることから、モデルを作ることが好きです。';
$string['learningstyles.K11'] = '私は、作文および要約を書くより、プロジェクトでの作業を好みます。';

?>
