<?php
/**
 *
 * @package    mahara
 * @subpackage form-element
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL version 3 or later
 * @copyright  For copyright information on Mahara, please see the README file distributed with this software.
 *
 */

function pieform_element_checkboxes(Pieform $form, $element) {/*{{{*/
    $global = ($form->get_property('method') == 'get') ? $_GET : $_POST;

    $submitted = $form->is_submitted();
    if ($submitted) {
        $value = isset($global[$element['name']]) ? $global[$element['name']] : array();
    }

    $result = '';

    if (count($element['elements']) > 1) {
        $id = hsc($form->get_name() . '_' . $element['name']) . '_container';
        $result .= '<a href="" onclick="pieform_element_checkboxes_update(\'' . $id . '\', true); return false;">' . get_string('All') . '</a>'
            . '&nbsp;'
            . ' <a href="" onclick="pieform_element_checkboxes_update(\'' . $id . '\', false); return false;">' . get_string('none') . '</a>';
    }

    $result .= '<div class="cl"></div>';

    $element['name'] .= '[]';

    // Number of characters in checkbox labels (use 0 or false for no limit).
    $labelwidth = isset($element['labelwidth']) ? (int) $element['labelwidth'] : 17;

    foreach ($element['elements'] as $e) {
        if (!$submitted || !empty($e['disabled'])) {
            $checked = $e['defaultvalue'];
        }
        else {
            $checked = !empty($value[$e['value']]) || in_array($e['value'], $value);
        }
        $title = $labelwidth ? str_shorten_text($e['title'], $labelwidth, true) : $e['title'];
        $result .= '<div class="checkboxes-option"><input type="checkbox" value="' . $e['value'] . '" '
        . $form->element_attributes($element)
        . ($checked ? ' checked="checked"' : '')
        . (!empty($e['disabled']) ? ' disabled' : '')
        . '>' . Pieform::hsc($title) . '</div>';
    }
    $result .= '<div class="cl"></div>';

    return $result;
}/*}}}*/

function pieform_element_checkboxes_get_value(Pieform $form, $element) {/*{{{*/
    $global = ($form->get_property('method') == 'get') ? $_GET : $_POST;
    if (isset($element['value'])) {
        $values = (array) $element['value'];
    }
    else if ($form->is_submitted() && isset($global[$element['name']])) {
        $values = (array) $global[$element['name']];
    }
    else if (!$form->is_submitted() && isset($element['defaultvalue'])) {
        $values = (array) $element['defaultvalue'];
    }
    else {
        $values = array();
    }

    return $values;
}/*}}}*/

function pieform_element_checkboxes_js() {/*{{{*/
    return <<<EOF
function pieform_element_checkboxes_update(p, v) {
    forEach(getElementsByTagAndClassName('input', 'checkboxes', p), function(e) {
        if (!e.disabled) {
            e.checked = v;
        }
    });
    if (typeof formchangemanager !== 'undefined') {
        var form = jQuery('div#' + p).closest('form')[0];
        formchangemanager.setFormState(form, FORM_CHANGED);
    }
}
EOF;
}/*}}}*/

function pieform_element_checkboxes_get_headdata() {/*{{{*/
    $result = '<script type="text/javascript">' . pieform_element_checkboxes_js() . "\n</script>";
    return array($result);
}/*}}}*/
