<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2009 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage blocktype-popularviews
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2010 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

defined('INTERNAL') || die();

class PluginBlocktypePopularViews extends SystemBlocktype {

    public static function get_title() {
        return get_string('title', 'blocktype.popularviews');
    }

    public static function get_description() {
        return get_string('description', 'blocktype.popularviews');
    }

    public static function get_categories() {
        return array('general');
    }

    public static function get_viewtypes() {
        return array('dashboard');
    }

    public static function render_instance(BlockInstance $instance, $editing=false) {
        global $USER;
        require_once('view.php');
        $configdata = $instance->get('configdata');
        $pool = isset($configdata['pool']) ? intval($configdata['pool']) : get_config('popularviewspool');
        $limit = isset($configdata['limit']) ? intval($configdata['limit']) : get_config('popularviewsmax');
        $random = isset($configdata['random']) ? $configdata['random'] : get_config('popularviewsrandom');

        $sort = array(array('column' => 'visits', 'desc' => true));
        $views = View::view_search(null, null, null, null, $pool, 0, true, $sort, array('portfolio'));
        if ($random) {
            shuffle($views->data);
        }
        if (count($views->data) > $limit) {
            $viewslimit = min(array(count($views->data), $limit));
            $randomviews = array_chunk($views->data, $viewslimit);
        }
        $smarty = smarty_core();
        $smarty->assign('loggedin', $USER->is_logged_in());
        $smarty->assign('views', isset($randomviews) ? $randomviews[0] : $views->data);
        return $smarty->fetch('blocktype:popularviews:popularviews.tpl');
    }

    public static function has_instance_config() {
        return true;
    }

    public static function instance_config_form($instance) {
        $configdata = $instance->get('configdata');

        if (isset($configdata['random'])) {
            $random = $configdata['random'];
        }
        else {
            $random = true;
        }

        return array('limit' => array(
            'type' => 'text',
            'title' => get_string('viewstoshow', 'blocktype.popularviews'),
            'description' => get_string('viewstoshowdescription', 'blocktype.popularviews'),
            'defaultvalue' => (isset($configdata['limit'])) ? intval($configdata['limit']) : 10,
            'size' => 3,
            'minvalue' => 1,
            'maxvalue' => 100,
        ),
        'pool' => array(
            'type' => 'text',
            'title' => get_string('viewspool', 'blocktype.popularviews'),
            'description' => get_string('viewspooldescription', 'blocktype.popularviews'),
            'defaultvalue' => (isset($configdata['pool'])) ? intval($configdata['pool']) : 30,
            'size' => 3,
            'minvalue' => 1,
            'maxvalue' => 500,
        ),
        'random' => array(
            'type'         => 'checkbox',
            'title' => get_string('random', 'blocktype.popularviews'),
            'description' => get_string('randomdescription', 'blocktype.popularviews'),
            'defaultvalue' => (bool)$random,
        ));
    }

    public static function default_copy_type() {
        return 'shallow';
    }

    public static function get_instance_title(BlockInstance $instance) {
        return get_string('title', 'blocktype.popularviews');
    }
}
