<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2009 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage blocktype-mycollections
 * @author     Wullie Mair, using Catalyst IT Ltd code from /collection/index.php
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2012 Wullie Mair wmair@borderscollege.ac.uk
 *
 */

defined('INTERNAL') || die();
require_once('collection.php');


class PluginBlocktypeMycollections extends SystemBlocktype {

    public static function get_title() {
        return get_string('title', 'blocktype.mycollections');
    }

    public static function get_description() {
        return get_string('description', 'blocktype.mycollections');
    }
    
    public static function single_only() {
        return true;
    }

    public static function get_categories() {
        return array('internal');
    }

    public static function get_collectiontypes() {
        return array('profile', 'dashboard');
    }

    public static function render_instance(BlockInstance $instance, $editing=false) {

		$owner = $instance->get_view()->get('owner');

		$data = Collection::get_mycollections_data(0, 10);
		foreach ($data->data as $value) {
		    $collection = new Collection($value->id);
		    $views = $collection->get('views');
		    if (!empty($views)) {
        		$value->views = $views['views'];
		    }
		}

        $smarty = smarty_core();
		$smarty->assign('collections', $data->data);
        return $smarty->fetch('blocktype:mycollections:mycollections.tpl');
    }

    public static function has_instance_config() {
        return false;
    }

    public static function default_copy_type() {
        return 'shallow';
    }

    /**
     * MyCollections only makes sense for personal collections
     */
    public static function allowed_in_collections(Collection $collection) {
        return $collection->get('owner') != null;
    }

    public static function override_instance_title(BlockInstance $instance) {
        global $USER;
        $ownerid = $instance->get_view()->get('owner');
        if ($ownerid === null || $ownerid == $USER->get('id')) {
            return get_string('title', 'blocktype.mycollections');
        }
        return get_string('otherusertitle', 'blocktype.mycollections', display_name($ownerid, null, true));
    }

}
