<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2009 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage blocktype-linkedinshare
 * @author     Gregor Anzelj
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2012 Gregor Anzelj, gregor.anzelj@gmail.com
 *
 */

defined('INTERNAL') || die();

class PluginBlocktypeLinkedInShare extends SystemBlocktype {

    public static function single_only() {
        return true;
    }

    public static function get_title() {
        return get_string('title', 'blocktype.linkedinshare');
    }

    public static function get_description() {
        return get_string('description', 'blocktype.linkedinshare');
    }

    public static function get_categories() {
        return array('general');
    }

    public static function render_instance(BlockInstance $instance, $editing=false) {
        $configdata = $instance->get('configdata');
        $align      = (!empty($configdata['align'])) ? hsc($configdata['align']) : 'left';
        $layout     = (!empty($configdata['layout'])) ? hsc($configdata['layout']) : 'none';
		
		$full_self_url = urlencode(get_full_script_path());
		$result = '<div class="' . $align . '">';
		$result .= '<script src="http://platform.linkedin.com/in.js" type="text/javascript"></script>';
        $result .= '<script type="IN/Share"'
				  . ' data-url="' . $full_self_url . '"'
				  . ($layout != 'none' ? ' data-counter="' . $layout . '"' : '')
                  . '></script>';
		$result .= '</div>';
		return $result;
    }

    public static function has_instance_config() {
        return true;
    }

    public static function instance_config_form($instance) {
        $configdata = $instance->get('configdata');

        return array(
            'showtitle' => array(
                'type'  => 'checkbox',
                'title' => get_string('showtitle','blocktype.linkedinshare'),
                'defaultvalue' => (!empty($configdata['showtitle']) ? $configdata['showtitle'] : 0),
            ),
            'layout' => array(
                'type' => 'select',
                'title' => get_string('datacount','blocktype.linkedinshare'),
                'defaultvalue' => (!empty($configdata['layout']) ? $configdata['layout'] : 'none'),
				'options' => array(
					'none'  => get_string('datacountnone','blocktype.linkedinshare'),
					'right' => get_string('datacounthorizontal','blocktype.linkedinshare'),
					'top'   => get_string('datacountvertical','blocktype.linkedinshare'),
				),
            ),
            'align' => array(
                'type' => 'radio',
                'title' => get_string('align','blocktype.linkedinshare'),
                'defaultvalue' => (!empty($configdata['align'])) ? $configdata['align'] : 'left',
				'options' => array(
					'left' => get_string('alignleft','blocktype.linkedinshare'),
					'center' => get_string('aligncenter','blocktype.linkedinshare'),
					'right' => get_string('alignright','blocktype.linkedinshare'),
				),
				'separator' => '&nbsp;&nbsp;&nbsp;',
			),
        );
    }

    public static function instance_config_save($values) {
        if (empty($values['showtitle'])) {
			$values['title'] = null;
		}
		return $values;
	}
	
    public static function default_copy_type() {
        return 'full';
    }

}

?>
