<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2008 Catalyst IT Ltd (http://www.catalyst.net.nz)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage lang/fr.utf8
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @author     Your Name <your@email.address>
 * @copyright  (C) 2006-2011 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

defined('INTERNAL') || die();

$string['All'] = 'Tous';
$string['Artefact'] = 'Production';
$string['Artefacts'] = 'Productions';
$string['Close'] = 'Fermer';
$string['Copyof'] = 'Copie de %s';
$string['Created'] = 'Créé';
$string['Failed'] = 'Échec';
$string['From'] = 'De';
$string['Help'] = 'Aide';
$string['Hide'] = 'Cacher';
$string['Invitations'] = 'Invitations';
$string['Memberships'] = 'Affiliations';
$string['Organise'] = 'Organiser';
$string['Permissions'] = 'Permissions';
$string['Query'] = 'Requête';
$string['Requests'] = 'Requêtes';
$string['Results'] = 'Résultats';
$string['Site'] = 'Site';
$string['Tag'] = 'Tag';
$string['To'] = 'À';
$string['Total'] = 'Total';
$string['Updated'] = 'Mis à jour';
$string['Visits'] = 'Visites';
$string['about'] = 'À propos';
$string['accept'] = 'Accepter';
$string['accessforbiddentoadminsection'] = 'L\'accès à la section d\'administration vous est interdit';
$string['accesstotallydenied_institutionsuspended'] = 'Votre institution %s a été suspendue. Vous ne pourrez pas vous connecter à %s jusqu\'à ce qu\'elle soit réactivée.
Veuillez contacter votre institution si vous avez besoin d\'aide.';
$string['account'] = 'Mon compte';
$string['accountcreated'] = '%s : nouveau compte';
$string['accountcreatedchangepasswordhtml'] = '<p>Bonjour %s,</p>

<p>Un nouveau compte a été créé pour vous sur <a href="%s">%s</a>. Voici les données d\'accès :</p>

<ul>
    <li><strong>Nom d\'utilisateur :</strong> %s</li>
    <li><strong>Mot de passe :</strong> %s</li>
</ul>

<p>Lors de votre première connexion, vous devrez changer votre mot de passe.</p>

<p>Rendez-vous sur <a href="%s">%s</a> pour commencer !</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['accountcreatedchangepasswordtext'] = 'Bonjour %s,

Un nouveau compte a été créé pour vous sur %s. Voici les données d\'accès :

Nom d\'utilisateur : %s
Mot de passe :      %s

Lors de votre première connexion, vous devrez changer votre mot de passe.

Rendez-vous sur %s pour commencer !

Cordiales salutations, l\'administrateur du site %s';
$string['accountcreatedhtml'] = '<p>Bonjour %s,</p>

<p>Un nouveau compte a été créé pour vous sur <a href="%s">%s</a>. Voici les données d\'accès :</p>

<ul>
    <li><strong>Nom d\'utilisateur :</strong> %s</li>
    <li><strong>Mot de passe :</strong> %s</li>
</ul>

<p>Rendez-vous sur <a href="%s">%s</a> pour commencer !</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['accountcreatedtext'] = 'Bonjour %s,

Un nouveau compte a été créé pour vous sur %s. Voici les données d\'accès :

Nom d\'utilisateur : %s
Mot de passe :      %s

Rendez-vous sur %s pour commencer !

Cordiales salutations, l\'administrateur du site %s';
$string['accountdeleted'] = 'Désolé, votre compte a été supprimé';
$string['accountexpired'] = 'Désolé, votre compte est échu';
$string['accountexpirywarning'] = 'Avertissement d\'échéance de compte';
$string['accountexpirywarninghtml'] = '<p>Bonjour %s,</p>
    
<p>Votre compte sur %s arrivera à échéance dans %s.</p>

<p>Nous vous recommandons d\'enregistrer le contenu de votre portfolio à l\'aide du l\'outil d\'exportation. Les instructions d\'utilisation de cette fonctionnalité se trouvent dans le guide d\'utilisation.</p>

<p>Si vous désirez prolonger votre accès ou si vous avez des questions à ce sujet, veuillez <a href="%s">nous contacter</a>.</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['accountexpirywarningtext'] = 'Bonjour %s,

Votre compte sur %s arrivera à échéance dans %s.

Nous vous recommandons d\'enregistrer le contenu de votre portfolio à l\'aide du l\'outil d\'exportation. Les instructions d\'utilisation de cette fonctionnalité se trouvent dans le guide d\'utilisation.

Si vous désirez prolonger votre accès ou si vous avez des questions à ce sujet, veuillez nous contacter :

%s

Cordiales salutations, l\'administrateur du site %s';
$string['accountinactive'] = 'Désolé, votre compte est actuellement désactivé';
$string['accountinactivewarning'] = 'Avertissement de désactivation de compte';
$string['accountinactivewarninghtml'] = '<p>Bonjour %s,</p>

<p>Votre compte sur %s sera désactivé dans %s.</p>

<p>Une fois le compte désactivé, il ne sera plus possible de s\'y connecter jusqu\'à ce qu\'un administrateur ne le réactive.</p>

<p>Il vous est possible d\'éviter la désactivation en vous connectant maintenant.</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['accountinactivewarningtext'] = 'Bonjour %s,

Votre compte sur %s sera désactivé dans %s.

Une fois le compte désactivé, il ne sera plus possible de s\'y connecter jusqu\'à ce qu\'un administrateur ne le réactive.

Il vous est possible d\'éviter la désactivation en vous connectant maintenant.

Cordiales salutations, l\'administrateur du site %s';
$string['accountprefs'] = 'Préférences';
$string['accountsuspended'] = 'Votre compte a été suspendu le %s. La raison de la suspension est&nbsp;:<blockquote>%s</blockquote>';
$string['activityprefs'] = 'Préférences d\'activité';
$string['add'] = 'Ajouter';
$string['addemail'] = 'Ajouter adresse de courriel';
$string['adminphpuploaderror'] = 'Une erreur de dépôt de fichier a probablement été causée par la configuration de votre serveur.';
$string['allowpublicaccess'] = 'Permettre l\'accès au public (sans connexion)';
$string['alltags'] = 'Tous les tags';
$string['allusers'] = 'Tous les utilisateurs';
$string['alphabet'] = 'A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z';
$string['applychanges'] = 'Appliquer les modifications';
$string['artefact'] = 'production';
$string['artefactnotfound'] = 'La production %s n\'a pas été trouvée';
$string['artefactnotpublishable'] = 'La production %s n\'est pas publiable dans l\'exposition %s';
$string['artefactnotrendered'] = 'Production non traitée';
$string['at'] = 'à';
$string['attachment'] = 'Pièce jointe';
$string['back'] = 'Retour';
$string['backto'] = 'Retour à %s';
$string['belongingto'] = 'Appartenant à';
$string['bytes'] = 'octets';
$string['cancel'] = 'Annuler';
$string['cancelrequest'] = 'Annuler la demande';
$string['cannotremovedefaultemail'] = 'Vous ne pouvez pas retirer votre adresse de courriel principale';
$string['cantchangepassword'] = 'Désolé, vous ne pouvez pas changer de mot de passe dans cette interface. Veuillez pour cela utiliser l\'interface de votre institution';
$string['change'] = 'Changer';
$string['changepassword'] = 'Changer le mot de passe';
$string['changepasswordinfo'] = 'Vous devez changer votre mot de passe avant de continuer.';
$string['choosetheme'] = 'Choisir un thème...';
$string['chooseusernamepassword'] = 'Choisir votre nom d\'utilisateur et votre mot de passe';
$string['chooseusernamepasswordinfo'] = 'Pour vous connecter sur %s, vous devez disposer d\'un nom d\'utilisateur et d\'un mot de passe. Veuillez les choisir maintenant.';
$string['clambroken'] = 'Votre administrateur a activé le contrôle antivirus des fichiers déposés, mais la configuration est erronée. Votre fichier n\'a pas pu être déposé. L\'administrateur a reçu un message pour lui signaler le problème à corriger. Veuillez essayer de déposer votre fichier ultérieurement.';
$string['clamdeletedfile'] = 'Ce fichier a été supprimé';
$string['clamdeletedfilefailed'] = 'Le fichier n\'a pas pu être supprimé';
$string['clamemailsubject'] = '%s :: Notification Clam AV';
$string['clamfailed'] = 'Clam AV n\'a pas pu se lancer. Le message d\'erreur retourné est %s. Voici le message de Clam :';
$string['clamlost'] = 'Clam AV est configuré pour contrôler les fichiers déposés, mais le chemin d\'accès %s au logiciel Clam AV est incorrect.';
$string['clammovedfile'] = 'Le fichier a été déplacé dans un dossier de quarantaine.';
$string['clamunknownerror'] = 'Une erreur inconnue est survenue avec le logiciel Clam.';
$string['collapse'] = 'Compacter';
$string['complete'] = 'Compléter';
$string['config'] = 'Config';
$string['confirmdeletetag'] = 'Voulez-vous vraiment retirer ce tag de tous les éléments de votre portfolio ?';
$string['confirminvitation'] = 'Confirmer l\'invitation';
$string['confirmpassword'] = 'Confirmer le mot de passe';
$string['contactus'] = 'Contact';
$string['cookiesnotenabled'] = 'Les cookies sont désactivés dans votre navigateur, ou votre navigateur bloque les cookies provenant de ce site. Mahara a besoin des cookies pour que vous puissiez vous connecter';
$string['couldnotgethelp'] = 'Une erreur est survenue lors de la tentative de chargement de la page d\'aide';
$string['country.ad'] = 'Andorre';
$string['country.ae'] = 'Émirats Arabes Unis';
$string['country.af'] = 'Afghanistan';
$string['country.ag'] = 'Antigua et Barbuda';
$string['country.ai'] = 'Anguilla';
$string['country.al'] = 'Albanie';
$string['country.am'] = 'Arménie';
$string['country.an'] = 'Antilles Néerlandaises';
$string['country.ao'] = 'Angola';
$string['country.aq'] = 'Antarctique';
$string['country.ar'] = 'Argentine';
$string['country.as'] = 'Samoa américaines';
$string['country.at'] = 'Autriche';
$string['country.au'] = 'Australie';
$string['country.aw'] = 'Aruba';
$string['country.ax'] = 'Îles Åland';
$string['country.az'] = 'Azerbaïdjan';
$string['country.ba'] = 'Bosnie-Herzégovine';
$string['country.bb'] = 'Barbade';
$string['country.bd'] = 'Bangladesh';
$string['country.be'] = 'Belgique';
$string['country.bf'] = 'Burkina Faso';
$string['country.bg'] = 'Bulgarie';
$string['country.bh'] = 'Bahrein';
$string['country.bi'] = 'Burundi';
$string['country.bj'] = 'Bénin';
$string['country.bm'] = 'Bermudes';
$string['country.bn'] = 'Brunei Darussalam';
$string['country.bo'] = 'Bolivie';
$string['country.br'] = 'Brésil';
$string['country.bs'] = 'Bahamas';
$string['country.bt'] = 'Bhoutan';
$string['country.bv'] = 'Îles Bouvet';
$string['country.bw'] = 'Botswana';
$string['country.by'] = 'Bélarus';
$string['country.bz'] = 'Bélize';
$string['country.ca'] = 'Canada';
$string['country.cc'] = 'Île des Cocos';
$string['country.cd'] = 'République démocratique du Congo';
$string['country.cf'] = 'République centrafricaine';
$string['country.cg'] = 'République du Congo Brazzaville';
$string['country.ch'] = 'Suisse';
$string['country.ci'] = 'Côte d\'Ivoire';
$string['country.ck'] = 'Îles Cook';
$string['country.cl'] = 'Chili';
$string['country.cm'] = 'Cameroun';
$string['country.cn'] = 'Chine';
$string['country.co'] = 'Colombie';
$string['country.cr'] = 'Costa Rica';
$string['country.cs'] = 'Serbie et Monténégro';
$string['country.cu'] = 'Cuba';
$string['country.cv'] = 'Cap Vert';
$string['country.cx'] = 'Île Christmas';
$string['country.cy'] = 'Chypre';
$string['country.cz'] = 'République tchèque';
$string['country.de'] = 'Allemagne';
$string['country.dj'] = 'Djibouti';
$string['country.dk'] = 'Danemark';
$string['country.dm'] = 'Dominique';
$string['country.do'] = 'République dominicaine';
$string['country.dz'] = 'Algérie';
$string['country.ec'] = 'Équateur';
$string['country.ee'] = 'Estonie';
$string['country.eg'] = 'Égypte';
$string['country.eh'] = 'Sahara occidental';
$string['country.er'] = 'Érythrée';
$string['country.es'] = 'Espagne';
$string['country.et'] = 'Éthiopie';
$string['country.fi'] = 'Finlande';
$string['country.fj'] = 'Fidji';
$string['country.fk'] = 'Îles Malouines';
$string['country.fm'] = 'Micronésie';
$string['country.fo'] = 'Îles Féroé';
$string['country.fr'] = 'France';
$string['country.ga'] = 'Gabon';
$string['country.gb'] = 'Royaume-Uni';
$string['country.gd'] = 'Grenade';
$string['country.ge'] = 'Géorgie';
$string['country.gf'] = 'Guyane française';
$string['country.gg'] = 'Guernesey';
$string['country.gh'] = 'Ghana';
$string['country.gi'] = 'Gibraltar';
$string['country.gl'] = 'Groenland';
$string['country.gm'] = 'Gambie';
$string['country.gn'] = 'Guinée';
$string['country.gp'] = 'Guadeloupe';
$string['country.gq'] = 'Guinée Équatoriale';
$string['country.gr'] = 'Grèce';
$string['country.gs'] = 'Georgie du Sud et Îles Sandwich du Sud';
$string['country.gt'] = 'Guatemala';
$string['country.gu'] = 'Guam';
$string['country.gw'] = 'Guinée-Bissau';
$string['country.gy'] = 'Guyane';
$string['country.hk'] = 'Hong Kong';
$string['country.hm'] = 'Îles Heard et McDonald';
$string['country.hn'] = 'Honduras';
$string['country.hr'] = 'Croatie';
$string['country.ht'] = 'Haïti';
$string['country.hu'] = 'Hongrie';
$string['country.id'] = 'Indonésie';
$string['country.ie'] = 'Irlande';
$string['country.il'] = 'Israël';
$string['country.im'] = 'Île de Man';
$string['country.in'] = 'Inde';
$string['country.io'] = 'Territoire britannique de l\'Océan Indien';
$string['country.iq'] = 'Irak';
$string['country.ir'] = 'Iran';
$string['country.is'] = 'Islande';
$string['country.it'] = 'Italie';
$string['country.je'] = 'Jersey';
$string['country.jm'] = 'Jamaïque';
$string['country.jo'] = 'Jordanie';
$string['country.jp'] = 'Japon';
$string['country.ke'] = 'Kenya';
$string['country.kg'] = 'Kyrgyzstan';
$string['country.kh'] = 'Cambodge';
$string['country.ki'] = 'Kiribati';
$string['country.km'] = 'Comores';
$string['country.kn'] = 'Saint Kitts et Nevis';
$string['country.kp'] = 'Corée du Nord';
$string['country.kr'] = 'Corée du Sud';
$string['country.kw'] = 'Koweït';
$string['country.ky'] = 'Îles Cayman';
$string['country.kz'] = 'Kazakhstan';
$string['country.la'] = 'Laos';
$string['country.lb'] = 'Liban';
$string['country.lc'] = 'Saint Lucia';
$string['country.li'] = 'Liechtenstein';
$string['country.lk'] = 'Sri Lanka';
$string['country.lr'] = 'Liberia';
$string['country.ls'] = 'Lesotho';
$string['country.lt'] = 'Lituanie';
$string['country.lu'] = 'Luxembourg';
$string['country.lv'] = 'Lettonie';
$string['country.ly'] = 'Libye';
$string['country.ma'] = 'Maroc';
$string['country.mc'] = 'Monaco';
$string['country.md'] = 'Moldavie';
$string['country.mg'] = 'Madagascar';
$string['country.mh'] = 'Îles Marshall';
$string['country.mk'] = 'Macédoine';
$string['country.ml'] = 'Mali';
$string['country.mm'] = 'Myanmar (Birmanie)';
$string['country.mn'] = 'Mongolie';
$string['country.mo'] = 'Macao';
$string['country.mp'] = 'Îles Mariannes du Nord';
$string['country.mq'] = 'Martinique';
$string['country.mr'] = 'Mauritanie';
$string['country.ms'] = 'Montserrat';
$string['country.mt'] = 'Malte';
$string['country.mu'] = 'Île Maurice';
$string['country.mv'] = 'Maldives';
$string['country.mw'] = 'Malawi';
$string['country.mx'] = 'Mexique';
$string['country.my'] = 'Malaisie';
$string['country.mz'] = 'Mozambique';
$string['country.na'] = 'Namibie';
$string['country.nc'] = 'Nouvelle-Calédonie';
$string['country.ne'] = 'Niger';
$string['country.nf'] = 'Île Norfolk';
$string['country.ng'] = 'Nigeria';
$string['country.ni'] = 'Nicaragua';
$string['country.nl'] = 'Pays-Bas';
$string['country.no'] = 'Norvège';
$string['country.np'] = 'Népal';
$string['country.nr'] = 'Nauru';
$string['country.nu'] = 'Niue';
$string['country.nz'] = 'Nouvelle-Zélande';
$string['country.om'] = 'Oman';
$string['country.pa'] = 'Panama';
$string['country.pe'] = 'Pérou';
$string['country.pf'] = 'Polynésie française';
$string['country.pg'] = 'Papouasie-Nouvelle-Guinée';
$string['country.ph'] = 'Philippines';
$string['country.pk'] = 'Pakistan';
$string['country.pl'] = 'Pologne';
$string['country.pm'] = 'Saint-Pierre et Miquelon';
$string['country.pn'] = 'Pitcairn';
$string['country.pr'] = 'Porto Rico';
$string['country.ps'] = 'Territoire palestinien (occupée)';
$string['country.pt'] = 'Portugal';
$string['country.pw'] = 'Palau';
$string['country.py'] = 'Paraguay';
$string['country.qa'] = 'Qatar';
$string['country.re'] = 'La Réunion';
$string['country.ro'] = 'Roumanie';
$string['country.ru'] = 'Russie';
$string['country.rw'] = 'Rwanda';
$string['country.sa'] = 'Arabie Saoudite';
$string['country.sb'] = 'Îles Salomon';
$string['country.sc'] = 'Seychelles';
$string['country.sd'] = 'Soudan';
$string['country.se'] = 'Suède';
$string['country.sg'] = 'Singapour';
$string['country.sh'] = 'Sainte Hélène';
$string['country.si'] = 'Slovénie';
$string['country.sj'] = 'Svalbard et Île Jan Mayen';
$string['country.sk'] = 'Slovaquie';
$string['country.sl'] = 'Sierra Leone';
$string['country.sm'] = 'Saint-Marin';
$string['country.sn'] = 'Sénégal';
$string['country.so'] = 'Somalie';
$string['country.sr'] = 'Surinam';
$string['country.st'] = 'Sao Tomé et Principe';
$string['country.sv'] = 'El Salvador';
$string['country.sy'] = 'Syrie';
$string['country.sz'] = 'Swaziland';
$string['country.tc'] = 'Iles Turques et Caïques';
$string['country.td'] = 'Tchad';
$string['country.tf'] = 'Terres australes françaises';
$string['country.tg'] = 'Togo';
$string['country.th'] = 'Thaïlande';
$string['country.tj'] = 'Tadjikistan';
$string['country.tk'] = 'Tokelau';
$string['country.tl'] = 'Timor oriental';
$string['country.tm'] = 'Turkménistan';
$string['country.tn'] = 'Tunisie';
$string['country.to'] = 'Tonga';
$string['country.tr'] = 'Turquie';
$string['country.tt'] = 'Trinité et Tobago';
$string['country.tv'] = 'Tuvalu';
$string['country.tw'] = 'Taiwan';
$string['country.tz'] = 'Tanzanie';
$string['country.ua'] = 'Ukraine';
$string['country.ug'] = 'Ouganda';
$string['country.um'] = 'Petites Îles des États-Unis d\'Amérique';
$string['country.us'] = 'États-Unis d\'Amérique';
$string['country.uy'] = 'Uruguay';
$string['country.uz'] = 'Ouzbékistan';
$string['country.va'] = 'Saint-Siège (État de la Cité du Vatican)';
$string['country.vc'] = 'Saint Vincent et les Grenadines';
$string['country.ve'] = 'Vénézuéla';
$string['country.vg'] = 'îles Vierges britanniques';
$string['country.vi'] = 'îles Vierges américaines';
$string['country.vn'] = 'Viêtnam';
$string['country.vu'] = 'Vanuatu';
$string['country.wf'] = 'Wallis et Futuna';
$string['country.ws'] = 'Samoa';
$string['country.ye'] = 'Yémen';
$string['country.yt'] = 'Mayotte';
$string['country.za'] = 'Afrique du Sud';
$string['country.zm'] = 'Zambie';
$string['country.zw'] = 'Zimbabwe';
$string['createcollect'] = 'Créer et rassembler';
$string['createcollectsubtitle'] = 'Organiser votre portfolio';
$string['createyourresume'] = 'Créer votre <a href="%s">Curriculum vitae</a>';
$string['dashboarddescription'] = 'Votre tableau de bord est ce que vous voyiez en premier lors de votre connexion. Vous êtes le seul à y avoir accès.';
$string['date'] = 'Date';
$string['dateformatguide'] = 'Utilisez la forme AAAA/MM/JJ';
$string['datetimeformatguide'] = 'Utilisez la forme AAAA/MM/JJ HH:MM';
$string['day'] = 'jour';
$string['days'] = 'jours';
$string['debugemail'] = 'ATTENTION ! Ce message était destiné à %s <%s>, mais vous a été envoyé en raison du réglage « sendallemailto ».';
$string['decline'] = 'Décliner';
$string['default'] = 'Défaut';
$string['delete'] = 'Supprimer';
$string['deleteduser'] = 'Utilisateur supprimé';
$string['deletetag'] = 'Retirer <a href="%s">%s</a>';
$string['deletetagdescription'] = 'Retirer ce tag de tous les éléments de votre portfolio';
$string['description'] = 'Description';
$string['disable'] = 'Désactiver';
$string['displayname'] = 'Nom affiché';
$string['divertingemailto'] = 'Redirection du message vers %s';
$string['done'] = 'Terminé';
$string['edit'] = 'Modifier';
$string['editdashboard'] = 'Editer';
$string['editing'] = 'Modification';
$string['editmyprofilepage'] = 'Modifier la page profil';
$string['edittag'] = 'Modifier <a href="%s">%s</a>';
$string['edittagdescription'] = 'Tous les éléments de votre portfolio portant le tag « %s » seront modifiés';
$string['edittags'] = 'Modifier les tags';
$string['editthistag'] = 'Modifier ce tag';
$string['email'] = 'Courriel';
$string['emailaddress'] = 'Adresse de courriel';
$string['emailaddressorusername'] = 'Adresse de courriel ou nom d\'utilisateur';
$string['emailnotsent'] = 'Échec de l\'envoi de courriel. Message d\'erreur : "%s"';
$string['emailtoolong'] = 'Les adresses de courriel ne peuvent pas être plus longues que 255 caractères';
$string['enable'] = 'Activer';
$string['errorprocessingform'] = 'Une erreur est survenue lors du traitement de ce formulaire. Veuillez vérifier les champs indiqués et essayer à nouveau.';
$string['expand'] = 'Développer';
$string['filenotimage'] = 'Le fichier que vous avez déposé n\'est pas une image valable. Ce doit être un fichier en format PNG, JPEG ou GIF.';
$string['fileunknowntype'] = 'Le type de fichier que vous avez déposé n\'a pas peu être déterminé. Votre fichier est peut être corrompu ou il peut s\'agir d\'un problème de configuration. Veuillez contacter votre administrateur.';
$string['filter'] = 'Filtre';
$string['filterresultsby'] = 'Filtrer les résultats par';
$string['findfriends'] = 'Recherche d\'amis';
$string['findfriendslinked'] = 'Trouver des <a href="%s">Amis</a>';
$string['findgroups'] = 'Recherche de groupes';
$string['first'] = 'Premier';
$string['firstname'] = 'Prénom';
$string['firstpage'] = 'Première page';
$string['forgotpassemaildisabled'] = 'Désolé, l\'adresse de courriel pour le nom d\'utilisateur que vous avez entré est désactivée. Veuillez contacter un administrateur pour qu\'il puisse réinitialiser votre mot de passe pour vous.';
$string['forgotpassemailsendunsuccessful'] = 'Désolé, le message n\'a pas pu être envoyé par courriel. Nous nous en excusons. Veuillez essayer à nouveau dans quelques instants';
$string['forgotpassnosuchemailaddressorusername'] = 'L\'adresse de courriel ou le nom d\'utilisateur saisi ne correspond à aucun utilisateur de ce site';
$string['forgotpasswordenternew'] = 'Veuillez taper votre nouveau mot de passe';
$string['forgotusernamepassword'] = 'Mot de passe oublié';
$string['forgotusernamepasswordemailmessagehtml'] = '<p>Bonjour %s,</p>

<p>Une demande de nom d\'utilisateur/mot de passe a été effectuée pour votre compte sur %s.</p>

<p>Votre nom d\'utilisateur est <strong>%s</strong>.</p>

<p>Si vous désirez réinitialiser votre mot de passe, veuillez suivre le lien ci-dessous :</p>

<p><a href="%s">%s</a></p>

<p>Si vous n\'avez pas fait de demande de réinitialisation de mot de passe, veuillez ignorer ce message.</p>

<p>Si vous avez des questions à ce sujet, n\'hésitez pas à <a href="%s">nous contacter</a>.</p>

<p>Cordialement, Administrateur du site %s</p>';
$string['forgotusernamepasswordemailmessagetext'] = 'Bonjour %s,

Une demande de nom d\'utilisateur/mot de passe a été effectuée pour votre compte sur %s.

Votre nom d\'utilisateur est %s.

Si vous désirez réinitialiser votre mot de passe, veuillez suivre le lien ci-dessous :

%s

Si vous n\'avez pas fait de demande de réinitialisation de mot de passe, veuillez ignorer ce message.

Si vous avez des questions à ce sujet, n\'hésitez pas à nous contacter :

%s

Cordialement, Administrateur du site %s';
$string['forgotusernamepasswordemailsubject'] = 'Nom d\'utilisateur/mot de passe pour %s';
$string['forgotusernamepasswordtext'] = '<p>Si vous avez oublié votre nom d\'utilisateur ou votre mot de passe, tapez l\'adresse de courriel de votre profil et nous vous enverrons un message qui vous permettra de vous donner un nouveau mot de passe.</p>
<p>Si vous connaissez votre nom d\'utilisateur et avez oublié votre mot de passe, vous pouvez taper votre nom d\'utilisateur au lieu de votre adresse de courriel.</p>';
$string['formatpostbbcode'] = 'Vous pouvez formater votre message à l\'aide de la syntaxe BBCode. %sPlus d\'information%s';
$string['formerror'] = 'Une erreur s\'est produite lors de la soumission de votre demande. Veuillez essayer à nouveau.';
$string['formerroremail'] = 'Veuillez nous contacter à %s si vous continuez à avoir des problèmes de ce genre.';
$string['fullname'] = 'Nom complet';
$string['go'] = 'Aller';
$string['gotoinbox'] = 'Aller boîte de réception';
$string['groups'] = 'Groupes';
$string['height'] = 'Hauteur';
$string['heightshort'] = 'h';
$string['home'] = 'Accueil';
$string['howtodisable'] = 'Vous avez masqué la boîte d\'informations. Vous pouvez gérer son accès depuis les <a href="%s">Paramètres</a>.';
$string['image'] = 'Image';
$string['importedfrom'] = 'Importé depuis %s';
$string['inbox'] = 'Boîte de réception';
$string['incomingfolderdesc'] = 'Fichiers importés depuis d\'autres serveurs mis en réseau';
$string['installedplugins'] = 'Plug-ins installés';
$string['institution'] = 'Institution';
$string['institutionexpirywarning'] = 'Avis d\'échéance d\'institution';
$string['institutionexpirywarninghtml_institution'] = '<p>Bonjour %s,</p>

<p>L\'affiliation à %s de %s arrivera à échéance dans %s.</p>

<p>Si vous désirez étendre votre affiliation à l\'institution ou avez des questions à ce sujet, veuillez nous <a href="%s">contacter</a>.</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['institutionexpirywarninghtml_site'] = '<p>Bonjour %s,</p>

<p>L\'institution %s arrivera à échéance dans %s.</p>

<p>Vous pouvez la contacter si nécessaire pour étendre son affiliation à %s.</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['institutionexpirywarningtext_institution'] = 'Bonjour %s,

L\'affiliation à %s de %s arrivera à échéance dans %s.

Si vous désirez étendre votre affiliation à l\'institution ou avez des questions à ce sujet, veuillez nous contacter :

%s

Cordiales salutations, l\'administrateur du site %s';
$string['institutionexpirywarningtext_site'] = 'Bonjour %s,

L\'institution %s arrivera à échéance dans %s.

Vous pouvez la contacter si nécessaire pour étendre son affiliation à %s.

Cordiales salutations, l\'administrateur du site %s';
$string['institutionfull'] = 'L\'institution que vous avez sélectionnée n\'accepte plus d\'inscriptions.';
$string['institutionmemberconfirmmessage'] = 'Vous êtes maintenant membre de %s.';
$string['institutionmemberconfirmsubject'] = 'Confirmation d\'affiliation à une institution';
$string['institutionmemberrejectmessage'] = 'Votre demande d\'affiliation à %s a été rejetée.';
$string['institutionmemberrejectsubject'] = 'Demande d\'affiliation à une institution rejetée';
$string['institutionmembership'] = 'Institutions';
$string['institutionmembershipdescription'] = 'Si vous êtes membre d\'institutions, elles seront indiquées ici. Vous pouvez demander à devenir membre d\'une institution. D\'autre part, si une institution vous a invité à la rejoindre, vous pouvez accepter ou décliner l\'invitation.';
$string['institutionmembershipexpirywarning'] = 'Avertissement de fin d\'affiliation à une institution';
$string['institutionmembershipexpirywarninghtml'] = '<p>Bonjour %s,</p>

<p>Votre affiliation à %s sur %s arrivera à échéance dans %s.</p>

<p>Si vous désirez étendre votre affiliation ou si vous avez des questions à ce sujet, veuillez <a href="%s">nous contacter</a>.</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>';
$string['institutionmembershipexpirywarningtext'] = 'Bonjour %s,

Votre affiliation à %s sur %s arrivera à échéance dans %s.

Si vous désirez étendre votre affiliation ou si vous avez des questions à ce sujet, veuillez nous contacter :

%s

Cordiales salutations, l\'administrateur du site %s';
$string['invalidsesskey'] = 'Clef de session non valide';
$string['invitedgroup'] = 'groupe invité à';
$string['invitedgroups'] = 'groupes invités à';
$string['itemstaggedwith'] = 'Éléments portant le tag « %s »';
$string['javascriptnotenabled'] = 'JavaScript n\'est pas actif pour ce site dans votre navigateur. Mahara a besoin de JavaScript pour que vous puissiez vous connecter';
$string['joingroups'] = 'Rejoindre des <a href="%s">Groupes</a>';
$string['joininstitution'] = 'Rejoindre l\'institution';
$string['language'] = 'Langue';
$string['last'] = 'Dernier';
$string['lastminutes'] = '%s dernières minutes';
$string['lastname'] = 'Nom';
$string['lastpage'] = 'Dernière page';
$string['leaveinstitution'] = 'Quitter l\'institution';
$string['linksandresources'] = 'Liens et ressources';
$string['lo ginfailed'] = 'Vous n\'avez pas fourni les données correctes pour vous connecter. Veuillez vérifier que votre nom d\'utilisateur et votre mot de passe sont corrects.';
$string['loading'] = 'Chargement...';
$string['loggedinusersonly'] = 'Seulement utilisateurs connectés';
$string['loggedoutok'] = 'Votre déconnexion a réussi';
$string['login'] = 'Connexion';
$string['loginfailed'] = 'Les informations que vous avez données pour l\'authentification sont incorrectes. Veuillez contrôler votre nom d\'utilisateur et/ou votre mot de passe.';
$string['loginto'] = 'Se connecter à %s';
$string['logout'] = 'Déconnexion';
$string['lostusernamepassword'] = 'Mot de passe oublié';
$string['memberofinstitutions'] = 'Membre de %s';
$string['membershipexpiry'] = 'Votre affiliation arrive à échéance';
$string['message'] = 'Message';
$string['messagesent'] = 'Votre message a été envoyé';
$string['months'] = 'mois';
$string['more...'] = 'Plus...';
$string['mustspecifyoldpassword'] = 'Vous devez indiquer votre mot de passe actuel';
$string['mydashboard'] = 'Mon tableau de bord';
$string['myfriends'] = 'Mes amis';
$string['mygroups'] = 'Mes groupes';
$string['mymessages'] = 'Mes messages';
$string['myportfolio'] = 'Mon portfolio';
$string['mytags'] = 'Mes tags';
$string['myviews'] = 'Mes expositions';
$string['name'] = 'Nom';
$string['namedfieldempty'] = 'Le champ requis «%s» est vide';
$string['newpassword'] = 'Nouveau mot de passe';
$string['next'] = 'Suivant';
$string['nextpage'] = 'Page suivante';
$string['no'] = 'Non';
$string['nocountryselected'] = 'Aucun pays sélectionné';
$string['nodeletepermission'] = 'Vous n\'êtes pas autorisé à supprimer cette production';
$string['noeditpermission'] = 'Vous n\'êtes pas autorisé à modifier cette production';
$string['noenddate'] = 'Pas de date d\'échéance';
$string['nohelpfound'] = 'Il n\'y a pas d\'aide pour cet élément';
$string['nohelpfoundpage'] = 'L\'aide pour cette page n\'a pas été trouvée';
$string['noinstitutionsetpassemailmessagehtml'] = '<p>Bonjour %s,</p>

<p>Vous n\'êtes plus membre de %s.</p>
<p>Vous pouvez continuer à utiliser %s avec votre nom d\'utilisateur actuel %s, mais vous devez changer votre mot de passe.</p>

<p>Veuillez suivre le lien ci-dessous pour modifier le mot de passe.</p>

<p><a href="%sforgotpass.php?key=%s">%sforgotpass.php?key=%s</a></p>

<p>Si vous avez des questions à ce sujet, veuillez <a href="%scontact.php"> nous contacter</a>.</p>

<p>Cordiales salutations, l\'administrateur du site %s</p>

<p><a href="%sforgotpass.php?key=%s">%sforgotpass.php?key=%s</a></p>';
$string['noinstitutionsetpassemailmessagetext'] = 'Bonjour %s,

Vous n\'êtes plus membre de %s.
Vous pouvez continuer à utiliser %s avec votre nom d\'utilisateur actuel %s, mais vous devez changer votre mot de passe.

Veuillez suivre le lien ci-dessous pour modifier le mot de passe.

%sforgotpass.php?key=%s

Si vous avez des questions à ce sujet, veuillez nous contacter.

%scontact.php

Cordiales salutations, l\'administrateur du site %s

%sforgotpass.php?key=%s';
$string['noinstitutionsetpassemailsubject'] = '%s : affiliation à %s';
$string['none'] = 'Aucun';
$string['noresultsfound'] = 'Aucun résultat trouvé';
$string['nosendernamefound'] = 'Aucun expéditeur indiqué';
$string['nosessionreload'] = 'Recharger la page pour vous connecter';
$string['nosuchpasswordrequest'] = 'Il n\'y a pas de telle demande de changement de mot de passe';
$string['notifications'] = 'Notifications';
$string['notinstallable'] = 'Pas installable !';
$string['notinstalledplugins'] = 'Plug-ins non installés';
$string['notphpuploadedfile'] = 'Le fichier a été perdu lors de son dépôt. Cela ne devrait pas arriver. Veuillez demander plus d\'information à votre administrateur.';
$string['numitems'] = '%s éléments';
$string['oldpassword'] = 'Mot de passe actuel';
$string['onlineusers'] = 'Utilisateurs en ligne';
$string['optionalinstitutionid'] = 'Identifiant institution (optionnel)';
$string['organisedescription'] = 'Organiser votre portfolio sous formes d\' <a href="%s">Expositions.</a>  Créer différentes expositions pour différentes audiences - en sélectionnant les éléments à y inclure.';
$string['organisesubtitle'] = 'Présenter votre portfolio à l\'aide d\'expositions';
$string['password'] = 'Mot de passe';
$string['passwordchangedok'] = 'Votre mot de passe a été changé';
$string['passwordhelp'] = 'Le mot de passe pour accéder au système';
$string['passwordnotchanged'] = 'Vous n\'avez pas changé de mot de passe. Veuillez choisir un nouveau mot de passe';
$string['passwordsaved'] = 'Votre nouveau mot de passe a été enregistré';
$string['passwordsdonotmatch'] = 'Les mots de passe ne correspondent pas';
$string['passwordtooeasy'] = 'Votre mot de passe est trop simple ! Veuillez choisir un mot de passe plus compliqué';
$string['pendingfriend'] = 'ami en attente';
$string['pendingfriends'] = 'amis en attente';
$string['phpuploaderror'] = 'Une erreur est survenue lors du dépôt de fichier : %s (code d\'erreur %s)';
$string['phpuploaderror_1'] = 'La taille du fichier déposé dépasse la directive upload_max_filesize de php.ini.';
$string['phpuploaderror_2'] = 'La taille du fichier déposé dépasse la directive MAX_FILE_SIZE indiquée dans le formulaire HTML.';
$string['phpuploaderror_3'] = 'Le fichier n\'a été que partiellement déposé.';
$string['phpuploaderror_4'] = 'Aucun fichier n\'a été déposé.';
$string['phpuploaderror_6'] = 'Dossier temporaire manquant.';
$string['phpuploaderror_7'] = 'Échec de l\'écriture du fichier.';
$string['phpuploaderror_8'] = 'Dépôt du fichier stoppé par l\'extension.';
$string['pleasedonotreplytothismessage'] = 'Merci de ne pas répondre à ce message.';
$string['plugindisabled'] = 'Extension désactivée';
$string['pluginenabled'] = 'Extension activée';
$string['pluginnotenabled'] = 'Extension désactivée. Vous devez activer l\'extension %s auparavant.';
$string['plugintype'] = 'Type de plug-in';
$string['preferences'] = 'Préférences';
$string['preferredname'] = 'Nom choisi';
$string['previous'] = 'Précédent';
$string['prevpage'] = 'Page précédente';
$string['primaryemailinvalid'] = 'Votre adresse de courriel principale n\'est pas valide';
$string['privacystatement'] = 'Protection des données';
$string['processing'] = 'Traitement';
$string['profile'] = 'profil';
$string['profiledescription'] = 'Your profile view is what others see when they click on your name or profile icon';
$string['profileimage'] = 'Image du profil';
$string['publishablog'] = 'Publier un <a href="%s">Blog</a>';
$string['pwchangerequestsent'] = 'Vous allez prochainement recevoir par courriel un message contenant un lien vous permettant de changer le mot de passe de votre compte';
$string['quarantinedirname'] = 'quarantaine';
$string['query'] = 'Requête';
$string['querydescription'] = 'Termes à rechercher';
$string['quota'] = 'Quota';
$string['quotausage'] = 'Vous avez utilisé <span id="quota_used">%s</span> de votre quota de <span id="quota_total">%s</span>.';
$string['reallyleaveinstitution'] = 'Voulez-vous vraiment quitter cette institution ?';
$string['reason'] = 'Raison';
$string['recentactivity'] = 'Dernières activités';
$string['register'] = 'Enregistrement';
$string['registeragreeterms'] = 'Vous devez aussi accepter les <a href="terms.php">conditions d\'utilisation</a>.';
$string['registeringdisallowed'] = 'Désolé, il n\'est en ce moment pas possible de vous enregistrer sur ce site';
$string['registerprivacy'] = 'Les données collectées seront gérées selon notre <a href="privacy.php">charte de protection de la vie privée</a>.';
$string['registerstep3fieldsmandatory'] = '<h3>Remplir les champs obligatoires</h3><p>Les champs suivants sont requis. Vous devez les remplir pour poursuivre votre enregistrement.</p>';
$string['registerstep3fieldsoptional'] = '<h3>Choisissez une image de profil optionnelle</h3><p>Vous vous êtes enregistré sur le site %s ! Vous pouvez maintenant choisir pour votre profil une image qui sera affichée comme votre avatar.</p>';
$string['registerwelcome'] = 'Bienvenue ! Pour pouvoir utiliser ce site, vous devez vous enregistrer.';
$string['registrationcomplete'] = 'Merci pour votre inscription à %s';
$string['registrationnotallowed'] = 'L\'institution que vous avez sélectionnée n\'accepte pas d\'auto-inscriptions.';
$string['reject'] = 'Rejeter';
$string['remotehost'] = 'Serveur distant %s';
$string['remove'] = 'Retirer';
$string['republish'] = 'Publier';
$string['requestmembershipofaninstitution'] = 'Demander l\'affiliation à une institution';
$string['requiredfieldempty'] = 'Un champ requis est vide';
$string['result'] = 'résultat';
$string['results'] = 'résultat';
$string['returntosite'] = 'Retour au site';
$string['save'] = 'Enregistrer';
$string['search'] = 'Recherche';
$string['searchresultsfor'] = 'Résultats de la recherche pour';
$string['searchusers'] = 'Recherche utilisateurs';
$string['select'] = 'Sélectionner';
$string['selectatagtoedit'] = 'Choisir un tag à modifier';
$string['selfsearch'] = 'Chercher dans Mon Portfolio';
$string['send'] = 'Envoyer';
$string['sendmessage'] = 'Envoyer message';
$string['sendrequest'] = 'Envoyer demande';
$string['sessiontimedout'] = 'Votre session est échue. Veuillez saisir vos données de connexion pour continuer';
$string['sessiontimedoutpublic'] = 'Votre session est échue. Veuillez vous <a href="%s">connecter</a> pour continuer';
$string['sessiontimedoutreload'] = 'Votre session est échue. Rechargez la page pour vous connecter à nouveau';
$string['settings'] = 'Préférences';
$string['settingssaved'] = 'Préférences enregistrées';
$string['settingssavefailed'] = 'Échec de l\'enregistrement des préférences';
$string['sharenetwork'] = 'Partager et réseauter';
$string['sharenetworkdescription'] = 'Vous pouvez régler finement l\'accès de chacune de vos expositions, ainsi que la durée d\'accès.';
$string['sharenetworksubtitle'] = 'Rencontrer des amis et travailler en groupes';
$string['showtags'] = 'Afficher mes tags';
$string['siteadministration'] = 'Administration site';
$string['siteclosed'] = 'Le site est fermé temporairement en raison d\'une mise à jour de la base de données. Les administrateurs peuvent cependant se connecter.';
$string['siteclosedlogindisabled'] = 'Le site est fermé temporairement en raison d\'une mise à jour de la base de données. <a href="%s">Effectuez la mise à jour maintenant.</a>';
$string['sitecontentnotfound'] = 'Texte %s non disponible';
$string['sizeb'] = 'o';
$string['sizegb'] = 'Go';
$string['sizekb'] = 'Ko';
$string['sizemb'] = 'Mo';
$string['sortalpha'] = 'Trier les tags alphabétiquement';
$string['sortfreq'] = 'Trier les tags par fréquence';
$string['sortresultsby'] = 'Trier les résultats par';
$string['spamtrap'] = 'Attrappeur de spam';
$string['strftimenotspecified'] = 'Non indiqué';
$string['studentid'] = 'Identifiant ID';
$string['subject'] = 'Objet';
$string['submit'] = 'Envoyer';
$string['system'] = 'Système';
$string['tagdeletedsuccessfully'] = 'Tag supprimé';
$string['tagfilter_all'] = 'Tous';
$string['tagfilter_file'] = 'Fichiers';
$string['tagfilter_image'] = 'Images';
$string['tagfilter_text'] = 'Texte';
$string['tagfilter_view'] = 'Expositions';
$string['tags'] = 'Tags';
$string['tagsdesc'] = 'Pour cet élément, saisir une liste de tags séparés par des virgules';
$string['tagsdescprofile'] = 'Saisissez une liste de tags séparés par des virgules. Les éléments signalés par « profil » sont affichés dans votre barre latérale.';
$string['tagupdatedsuccessfully'] = 'Tag modifié';
$string['termsandconditions'] = 'Conditions d\'utilisation';
$string['theme'] = 'Thème';
$string['thisistheprofilepagefor'] = 'Ceci est la page du profil de %s';
$string['topicsimfollowing'] = 'Sujets que je suis';
$string['unknownerror'] = 'Une erreur inconnue est survenue (0x20f91a0)';
$string['unreadmessage'] = 'message non lu';
$string['unreadmessages'] = 'messages non lus';
$string['update'] = 'Mettre à jour';
$string['updatefailed'] = 'Échec de la mise à jour';
$string['updateyourprofile'] = 'Mettre à jour votre <a href="%s">Profil</a>';
$string['upload'] = 'Déposer';
$string['uploadedfiletoobig'] = 'Le fichier est trop volumineux. Veuillez demander plus d\'information à votre administrateur.';
$string['uploadyourfiles'] = 'Déposer vos <a href="%s">Fichiers</a>';
$string['useradministration'] = 'Administration utilisateurs';
$string['username'] = 'Nom d\'utilisateur';
$string['usernamehelp'] = 'Le nom d\'utilisateur qui vous a été attribué pour accéder à ce système.';
$string['users'] = 'Utilisateurs';
$string['usersdashboard'] = 'Tableau de bord de %s';
$string['usersprofile'] = '%s\'s Profile';
$string['view'] = 'Exposition';
$string['viewmyprofilepage'] = 'Consulter la page profil';
$string['views'] = 'Expositions';
$string['virusfounduser'] = 'Le fichier %s que vous avez déposé a été scanné par un anti-virus et diagnostiqué comme infecté! Le fichier n\'a pas été enregistré.';
$string['virusrepeatmessage'] = 'L\'utilisateur %s a déposé plusieurs fichiers diagnostiqués comme infectés par le logiciel anti-virus.';
$string['virusrepeatsubject'] = 'Attention ! %s dépose des fichiers infectés de façon répétée.';
$string['weeks'] = 'semaines';
$string['width'] = 'Largeur';
$string['widthshort'] = 'l';
$string['years'] = 'années';
$string['yes'] = 'Oui';
$string['youareamemberof'] = 'Vous êtes membre de %s';
$string['youaremasqueradingas'] = 'Vous êtes connecté sous le nom %s';
$string['youhavebeeninvitedtojoin'] = 'Vous avez été invité à rejoindre %s';
$string['youhavenottaggedanythingyet'] = 'Vous n\'avez encore pas attribué de tag';
$string['youhaverequestedmembershipof'] = 'Vous avez demander l\'affiliation à %s';
$string['youraccounthasbeensuspended'] = 'Votre compte a été suspendu';
$string['youraccounthasbeensuspendedreasontext'] = 'Votre compte sur %s a été suspendu par %s. Raison donnée : %s';
$string['youraccounthasbeensuspendedtext2'] = 'Votre compte sur %s a été suspendu par %s.';
$string['youraccounthasbeenunsuspended'] = 'Votre compte a été réactivé';
$string['youraccounthasbeenunsuspendedtext2'] = 'Votre compte sur %s a été réactivé. Vous pouvez de nouveau vous connecter et utiliser le site.';
$string['yournewpassword'] = 'Votre nouveau mot de passe';
$string['yournewpasswordagain'] = 'Votre nouveau mot de passe (confirmation)';
?>
